/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.arsdelight.content.block;

import dev.xkmc.arsdelight.init.food.ADFood;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vectorwing.farmersdelight.common.block.FeastBlock;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class SaladFeast
extends FeastBlock {
    private static final VoxelShape BASE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
    private static final VoxelShape LOW = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0));
    private static final VoxelShape HIGH = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0));

    public SaladFeast(BlockBehaviour.Properties properties, Supplier<Item> servingItem, boolean hasLeftovers) {
        super(properties, servingItem, hasLeftovers);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int s = (Integer)state.getValue((Property)SERVINGS);
        return s == 0 ? BASE : (s == 1 ? LOW : HIGH);
    }

    protected ItemInteractionResult takeServing(LevelAccessor level, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        ItemInteractionResult ans = this.takeServingImpl(level, pos, state, player, hand, ADFood.HORN_ROLL.asStack(), false);
        if (ans.consumesAction()) {
            return ans;
        }
        return this.takeServingImpl(level, pos, state, player, hand, ADFood.BOWL_OF_WILDEN_SALAD.asStack(), true);
    }

    protected ItemInteractionResult takeServingImpl(LevelAccessor level, BlockPos pos, BlockState state, Player player, InteractionHand hand, ItemStack serving, boolean fin) {
        int servings = (Integer)state.getValue((Property)this.getServingsProperty());
        if (servings == 0) {
            level.playSound((Player)null, pos, SoundEvents.WOOD_BREAK, SoundSource.PLAYERS, 0.8f, 0.8f);
            level.destroyBlock(pos, true);
            return ItemInteractionResult.SUCCESS;
        }
        ItemStack heldStack = player.getItemInHand(hand);
        if (servings > 0) {
            if (!serving.hasCraftingRemainingItem() || ItemStack.isSameItem((ItemStack)heldStack, (ItemStack)serving.getCraftingRemainingItem())) {
                level.setBlock(pos, (BlockState)state.setValue((Property)this.getServingsProperty(), (Comparable)Integer.valueOf(servings - 1)), 3);
                if (!player.getAbilities().instabuild && serving.hasCraftingRemainingItem()) {
                    heldStack.shrink(1);
                }
                if (!player.getInventory().add(serving)) {
                    player.drop(serving, false);
                }
                if ((Integer)level.getBlockState(pos).getValue((Property)this.getServingsProperty()) == 0 && !this.hasLeftovers) {
                    level.removeBlock(pos, false);
                }
                level.playSound((Player)null, pos, (SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.SUCCESS;
            }
            if (fin) {
                player.displayClientMessage((Component)TextUtils.getTranslation((String)"block.feast.use_container", (Object[])new Object[]{serving.getCraftingRemainingItem().getHoverName()}), true);
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

